/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.changepw;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.PmDataBean;
import com.ibm.hwmca.fw.servlet.pmod.event.ModelActionEvent;
import com.ibm.hwmca.fw.servlet.pmod.event.ModelActionListener;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.tasklet.Client;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.PasswordValidation;
import com.ibm.hwmca.fw.util.Trace;

public class ChangePWTask
extends PresentationTask
implements PmDataBean,
ModelActionListener {
    private static final String TRACE_MASKT = "XCPWTSKT";
    private static final String RESOURCE_BUNDLE = "com.ibm.hwmca.fw.changepw.res.changepw";
    private static final String MANAGER_SERVICE_TASKLET = "com.ibm.hwmca.fw.changepw.PWManagerService";
    public static final short CLIENT_RUN_ERROR = 2353;
    private boolean forced;
    private boolean taskCompleted;
    protected PanelModel mainPanelModel;
    protected boolean strictPasswordRules;
    protected boolean pwIsCaseSensitive;
    protected boolean userIsServiceRole;
    protected String currentPW = "";
    protected String newPW = "";
    protected String confirmNewPW = "";
    protected Client managerService;

    public ChangePWTask(PresentationTaskParms parms) {
        super(parms);
        String mode = (String)this.getParms().getData("mode");
        this.forced = mode != null && mode.equalsIgnoreCase("forced");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runTask() throws Exception {
        if (this.forced) {
            this.getPanelModelTaskPortal().setRefreshEnabled(false);
            this.getPanelModelTaskPortal().setEmbedded(true);
        }
        try {
            this.managerService = new Client(MANAGER_SERVICE_TASKLET, null);
            this.managerService.init();
            this.getUserInfo();
            this.showMainPanel();
            Object var1_1 = null;
            Object var3_2 = null;
            if (this.managerService != null) {
                this.managerService.terminate();
            }
            return var1_1;
        }
        catch (Throwable throwable) {
            block4: {
                Object var3_3 = null;
                if (this.managerService == null) break block4;
                this.managerService.terminate();
            }
            throw throwable;
        }
    }

    protected void showMainPanel() {
        this.mainPanelModel = new PanelModel("com.ibm.hwmca.fw.changepw.res.main", RESOURCE_BUNDLE, this, this.getHMCSession().getUserContext().getLocales());
        this.mainPanelModel.addModelActionListener(this);
        this.mainPanelModel.render();
        this.waitForTaskToFinish();
    }

    public void logException(Throwable throwable) {
        FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "ChangePWTask");
        new FrameworkLog(classLogInfo, 2353, throwable).log();
    }

    protected void forceTermination(String reason) {
        this.setCompletionInfo("changedpw=no");
    }

    protected void processOK() {
        if (!(this.forced || this.currentPW != null && this.currentPW.length() != 0)) {
            this.showErrorMessage("incorrectInputTitle", "mustEnterCurrentPW");
            return;
        }
        if (this.newPW == null || this.newPW.length() == 0 || this.confirmNewPW == null || this.confirmNewPW.length() == 0) {
            this.showErrorMessage("incorrectInputTitle", "mustEnterNewPWs");
            return;
        }
        boolean matches = this.pwIsCaseSensitive ? this.newPW.equals(this.confirmNewPW) : this.newPW.equalsIgnoreCase(this.confirmNewPW);
        if (!matches) {
            this.showErrorMessage("incorrectInputTitle", "pwsDontMatch");
            return;
        }
        if (!this.forced && !this.isPasswordCorrect(this.currentPW)) {
            this.showErrorMessage("incorrectInputTitle", "pwIsWrong");
            return;
        }
        if (this.strictPasswordRules) {
            if (!PasswordValidation.isPasswordValid(this.newPW)) {
                return;
            }
        } else {
            if (!PasswordValidation.isNonStrictPasswordValid(this.newPW)) {
                return;
            }
            if (this.isPasswordCorrect(this.newPW)) {
                this.showErrorMessage("incorrectInputTitle", "pwIsNotNew");
                return;
            }
        }
        this.setPassword(this.newPW);
        try {
            LocalizableText[] buttons = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
            LocalizableText title = new LocalizableText(RESOURCE_BUNDLE, "pwIsChangedTitle");
            MessageText[] messages = new MessageText[this.userIsServiceRole ? 2 : 1];
            messages[0] = new MessageText(RESOURCE_BUNDLE, "pwIsChangedMessage");
            if (this.userIsServiceRole) {
                messages[1] = new BaseMessageText("ADM0028");
            }
            CommonMsgApp.showMessageBox(null, title, messages, null, MsgType.INFORMATION_MESSAGE, buttons);
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKT, "Ignoring exception rendering password change message");
            Trace.trace(TRACE_MASKT, e);
        }
        this.setCompletionInfo("changedpw=yes");
    }

    protected void processCancel() {
        this.setCompletionInfo("changedpw=no");
    }

    public void actionPerformed(ModelActionEvent event) {
        String command = event.getActionCommand();
        Trace.trace(TRACE_MASKT, "Processing ChangePW action command \"" + command + "\".");
        if (command.equals("ok")) {
            this.processOK();
        } else if (command.equals("cancel")) {
            this.processCancel();
        }
    }

    private synchronized void waitForTaskToFinish() {
        Trace.trace(TRACE_MASKT, "ChangePW waiting for user to close the task.");
        while (!this.taskCompleted) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCompletionInfo(String parms) {
        if (this.forced) {
            String redirectURL = ServletRuntime.getRuntime().getHMCContextPath() + "/connect?" + parms;
            Trace.trace(TRACE_MASKT, "Setting redirect URL to: " + redirectURL);
            this.getPanelModelTaskPortal().setRedirectURL(redirectURL);
        }
        this.mainPanelModel.dispose();
        ChangePWTask changePWTask = this;
        synchronized (changePWTask) {
            this.taskCompleted = true;
            this.notify();
        }
    }

    protected void getUserInfo() throws TaskletException {
        TaskletRequest request = new TaskletRequest();
        request.setData("operation", "getUserInfo");
        TaskletResponse response = this.managerService.request(request);
        this.strictPasswordRules = (Boolean)response.getData("strictRules");
        this.pwIsCaseSensitive = (Boolean)response.getData("pwCaseSensitive");
        this.userIsServiceRole = (Boolean)response.getData("userIsServiceRole");
        Trace.trace(TRACE_MASKT, "User strict password checking rules == " + this.strictPasswordRules);
        Trace.trace(TRACE_MASKT, "User password case sensitivity == " + this.pwIsCaseSensitive);
        Trace.trace(TRACE_MASKT, "User is service role == " + this.userIsServiceRole);
    }

    protected boolean isPasswordCorrect(String password) {
        try {
            TaskletRequest request = new TaskletRequest();
            request.setData("operation", "isPasswordCorrect");
            request.setData("password", password);
            TaskletResponse response = this.managerService.request(request);
            boolean result = (Boolean)response.getData("correct");
            Trace.trace(TRACE_MASKT, "Submitted password is " + (result ? "" : "not ") + "correct.");
            return result;
        }
        catch (TaskletException e) {
            throw new RuntimeException("Error checking password", e);
        }
    }

    protected void setPassword(String password) {
        try {
            TaskletRequest request = new TaskletRequest();
            request.setData("operation", "setPassword");
            request.setData("password", password);
            TaskletResponse response = this.managerService.request(request);
            Trace.trace(TRACE_MASKT, "Password was changed.");
        }
        catch (TaskletException e) {
            throw new RuntimeException("Error setting password", e);
        }
    }

    protected void showErrorMessage(String titleKey, String messageKey) {
        this.showErrorMessage(titleKey, messageKey, null);
    }

    protected void showErrorMessage(String titleKey, String messageKey, Object[] substitutionData) {
        try {
            LocalizableText[] buttons = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
            LocalizableText title = new LocalizableText(RESOURCE_BUNDLE, titleKey);
            MessageText message = new MessageText(RESOURCE_BUNDLE, messageKey, substitutionData);
            CommonMsgApp.showMessageBox(null, title, message, MsgType.ERROR_MESSAGE, buttons);
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKT, "Ignoring exception rendering error message with key==" + messageKey);
            Trace.trace(TRACE_MASKT, e);
        }
    }

    public boolean isForcedChange() {
        return this.forced;
    }

    public boolean isStrictChecking() {
        return this.strictPasswordRules;
    }

    public void setCurrentPW(String pw) {
        this.currentPW = pw;
    }

    public String getCurrentPW() {
        return this.currentPW;
    }

    public void setNewPW(String pw) {
        this.newPW = pw;
    }

    public String getNewPW() {
        return this.newPW;
    }

    public void setConfirmNewPW(String pw) {
        this.confirmNewPW = pw;
    }

    public String getConfirmNewPW() {
        return this.confirmNewPW;
    }
}

